/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.disk;

import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskContainerContext;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskListener;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.tile.grid.portable.IPortableGrid;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class StorageDiskFluidPortable
implements IStorageDisk<FluidStack> {
    private final IStorageDisk<FluidStack> parent;
    private final IPortableGrid portableGrid;

    public StorageDiskFluidPortable(IStorageDisk<FluidStack> parent, IPortableGrid portableGrid) {
        this.parent = parent;
        this.portableGrid = portableGrid;
    }

    @Override
    public long getCapacity() {
        return this.parent.getCapacity();
    }

    @Override
    public void setSettings(@Nullable IStorageDiskListener listener, IStorageDiskContainerContext context) {
        this.parent.setSettings(listener, context);
    }

    @Override
    public NBTTagCompound writeToNbt() {
        return this.parent.writeToNbt();
    }

    @Override
    public Collection<FluidStack> getStacks() {
        return this.parent.getStacks();
    }

    @Override
    public Collection<StackListEntry<FluidStack>> getEntries() {
        return this.parent.getEntries();
    }

    @Override
    @Nullable
    public StackListResult<FluidStack> insert(@Nonnull FluidStack stack, long size, Action action) {
        long inserted;
        long storedPre = this.parent.getStored();
        StackListResult<FluidStack> remainder = this.parent.insert(stack, size, action);
        if (action == Action.PERFORM && (inserted = this.parent.getCacheDelta(storedPre, size, remainder == null ? 0L : remainder.getCount())) > 0L) {
            this.portableGrid.getFluidCache().add(stack, inserted, false);
        }
        return remainder;
    }

    @Override
    @Nullable
    public StackListResult<FluidStack> extract(@Nonnull FluidStack stack, long size, int flags, Action action) {
        StackListResult<FluidStack> extracted = this.parent.extract(stack, size, flags, action);
        if (action == Action.PERFORM && extracted != null) {
            this.portableGrid.getFluidCache().remove(extracted.getStack(), extracted.getCount(), false);
        }
        return extracted;
    }

    @Override
    public long getStored() {
        return this.parent.getStored();
    }

    @Override
    public int getPriority() {
        return this.parent.getPriority();
    }

    @Override
    public AccessType getAccessType() {
        return this.parent.getAccessType();
    }

    @Override
    public long getCacheDelta(long storedPreInsertion, long size, long remainder) {
        return this.parent.getCacheDelta(storedPreInsertion, size, remainder);
    }

    @Override
    public String getId() {
        return this.parent.getId();
    }
}

